/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.repair.panel;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystemManager;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.managedsystem.fru.filter.AllFrusFilter;
import com.ibm.hwmca.fw.tasklet.SynchronousPanelTasklet;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.panel.repair.ExchLocPanelBean;
import com.ibm.hwmca.xfw.panel.repair.SelExchPartsPanelBean;
import com.ibm.hwmca.xfw.repair.panel.DescPanelHandler;
import com.ibm.hwmca.xfw.repair.panel.StatusPanelHandler;
import com.ibm.hwmca.xfw.repair.panel.XFConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SelExchPartsPanelHandler {
    private static final String TRACE_MASKT = "XRVX046T";
    private static final String TRACE_MASKF = "XRVX046F";
    private static final String TRACE_MASKD = "XRVX046D";
    private SynchronousPanelTasklet displayHandle;

    public SelExchPartsPanelHandler(SynchronousPanelTasklet displayHandle) {
        Trace.trace(TRACE_MASKT, "<-> SelExchPartsPanel ctor");
        this.displayHandle = displayHandle;
    }

    public void display(Map userData) throws HException {
        Trace.trace(TRACE_MASKT, "-> SelExchPartsPanelHandler.display");
        SelExchPartsPanelBean pb = new SelExchPartsPanelBean();
        Problem problem = (Problem)userData.get("PROBLEM");
        if (!(problem instanceof CommonProblem)) {
            throw new HException("selected problem is not a CommonProblem");
        }
        CommonProblem commonProblem = (CommonProblem)problem;
        ManagedSystem ms = ManagedSystemManager.getManager().getManagedSystem(commonProblem.getFailingSystem().getMachineType(), commonProblem.getFailingSystem().getMachineModel(), commonProblem.getFailingSystem().getMachineSerial());
        List fruList = ms.filter(AllFrusFilter.ALL_FRUS);
        Iterator fruIt = fruList.iterator();
        Fru[] frus = new Fru[fruList.size()];
        int aii = 0;
        while (fruIt.hasNext()) {
            frus[aii] = (Fru)fruIt.next();
            pb.setExchPartsLocRowAt(aii, new String[]{(String)frus[aii].getProperties().get("LOCATION")});
            ++aii;
        }
        boolean loop1done = false;
        while (!loop1done) {
            userData.put("EXCHANGED_FRUS", null);
            pb = (SelExchPartsPanelBean)this.displayHandle.replace(XFConstants.RES_FILE_NAME, "SelExchPartsPanel", pb);
            userData.put("LAST_PANEL_ACTION", pb.getActionCommand().toUpperCase());
            if (pb.getActionCommand().toUpperCase().equals("OKBUTTON")) {
                int[] selected = pb.getExchPartsLocSelection();
                if (selected != null && selected.length > 0) {
                    ExchLocPanelBean[] panelBeans = new ExchLocPanelBean[selected.length];
                    int aii2 = 0;
                    while (aii2 < selected.length) {
                        panelBeans[aii2] = new ExchLocPanelBean();
                        panelBeans[aii2].load();
                        if (aii2 == 0) {
                            panelBeans[aii2].disablePrevious();
                        }
                        panelBeans[aii2].setLocationOutput((String)frus[selected[aii2]].getProperties().get("LOCATION"));
                        Trace.trace(TRACE_MASKD, "SelExchPartsPanelHandler - adding part #:" + frus[selected[aii2]].getProperties().get("PART_NUM"));
                        panelBeans[aii2].setPartNumOutput((String)frus[selected[aii2]].getProperties().get("PART_NUM"));
                        panelBeans[aii2].setPartNumTextField((String)frus[selected[aii2]].getProperties().get("PART_NUM"));
                        Trace.trace(TRACE_MASKD, "SelExchPartsPanelHandler - adding EC level:" + (String)frus[selected[aii2]].getProperties().get("EC_LEVEL"));
                        panelBeans[aii2].setECNumOutput((String)frus[selected[aii2]].getProperties().get("EC_LEVEL"));
                        panelBeans[aii2].setECNumTextField((String)frus[selected[aii2]].getProperties().get("EC_LEVEL"));
                        Trace.trace(TRACE_MASKD, "SelExchPartsPanelHandler - adding serial #:" + (String)frus[selected[aii2]].getProperties().get("SERIAL_NUM"));
                        panelBeans[aii2].setSerNumOutput((String)frus[selected[aii2]].getProperties().get("SERIAL_NUM"));
                        if (aii2 + 1 == selected.length) {
                            panelBeans[aii2].disableNext();
                            panelBeans[aii2].enableOK();
                        }
                        ++aii2;
                    }
                    boolean loop2done = false;
                    int panelBeanNumber = 0;
                    while (!loop2done) {
                        panelBeans[panelBeanNumber] = (ExchLocPanelBean)this.displayHandle.replace(XFConstants.RES_FILE_NAME, "ExchLocPanel", panelBeans[panelBeanNumber]);
                        userData.put("LAST_PANEL_ACTION", panelBeans[panelBeanNumber].getActionCommand().toUpperCase());
                        if (panelBeans[panelBeanNumber].getActionCommand().toUpperCase().equals("NEXTPARTBUTTON")) {
                            if (!this.validInput(frus[selected[panelBeanNumber]], panelBeans[panelBeanNumber])) continue;
                            ++panelBeanNumber;
                            continue;
                        }
                        if (panelBeans[panelBeanNumber].getActionCommand().toUpperCase().equals("PREVIOUSPARTBUTTON")) {
                            --panelBeanNumber;
                            continue;
                        }
                        if (panelBeans[panelBeanNumber].getActionCommand().toUpperCase().equals("OKBUTTON")) {
                            if (!this.validInput(frus[selected[panelBeanNumber]], panelBeans[panelBeanNumber])) continue;
                            int aii3 = 0;
                            while (aii3 < selected.length) {
                                this.updateFru(frus[selected[aii3]], panelBeans[aii3], userData);
                                ++aii3;
                            }
                            this.displayRemainingPanels(userData);
                            if (!((String)userData.get("LAST_PANEL_ACTION")).equals("OKBUTTON")) continue;
                            loop2done = true;
                            loop1done = true;
                            continue;
                        }
                        loop2done = true;
                    }
                    continue;
                }
                this.displayRemainingPanels(userData);
                if (!pb.getActionCommand().toUpperCase().equals("OKBUTTON")) continue;
                loop1done = true;
                continue;
            }
            loop1done = true;
        }
        Trace.trace(TRACE_MASKT, "<- SelExchPartsPanelHandler.display");
    }

    private void displayRemainingPanels(Map userData) throws HException {
        Problem problem = (Problem)userData.get("PROBLEM");
        if (problem.getProblemNumber() == Integer.MIN_VALUE) {
            new DescPanelHandler(this.displayHandle).display(userData);
        } else {
            new StatusPanelHandler(this.displayHandle).display(userData);
        }
    }

    private void updateFru(Fru fru, ExchLocPanelBean pb, Map userData) throws HException {
        Trace.trace(TRACE_MASKD, "-> SelExchPartsPanelHandler.updateFru, fru=" + fru);
        String sernumFromBean = pb.getSerNumTextField();
        String partnumFromBean = pb.getPartNumTextField();
        String eclevelFromBean = pb.getECNumTextField();
        boolean updated = false;
        String sernumFromFru = (String)fru.getProperties().get("SERIAL_NUM");
        String partnumFromFru = (String)fru.getProperties().get("PART_NUM");
        String eclevelFromFru = (String)fru.getProperties().get("EC_LEVEL");
        ArrayList<PersistentData> exchangedFrus = (ArrayList<PersistentData>)userData.get("EXCHANGED_FRUS");
        if (exchangedFrus == null) {
            exchangedFrus = new ArrayList<PersistentData>();
            userData.put("EXCHANGED_FRUS", exchangedFrus);
        }
        exchangedFrus.add(fru.getPersistentData());
        if (!(sernumFromBean == null || sernumFromBean.length() <= 0 || sernumFromFru != null && sernumFromFru.equals(sernumFromBean))) {
            fru.getProperties().put("SERIAL_NUM", sernumFromBean);
            updated = true;
        }
        if (!(partnumFromBean == null || partnumFromBean.length() <= 0 || partnumFromFru != null && partnumFromFru.equals(partnumFromBean))) {
            fru.getProperties().put("PART_NUM", partnumFromBean);
            updated = true;
        }
        if (!(eclevelFromBean == null || eclevelFromBean.length() <= 0 || eclevelFromFru != null && eclevelFromFru.equals(eclevelFromBean))) {
            fru.getProperties().put("EC_LEVEL", eclevelFromBean);
            updated = true;
        }
        if (updated) {
            try {
                Trace.trace(TRACE_MASKD, "updateFru - updating fru[" + fru + "]");
                CommonProblem commonProblem = (CommonProblem)userData.get("PROBLEM");
                ManagedSystem ms = ManagedSystemManager.getManager().getManagedSystem(commonProblem.getFailingSystem().getMachineType(), commonProblem.getFailingSystem().getMachineModel(), commonProblem.getFailingSystem().getMachineSerial());
                ms.update(fru);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "<-! updateFru - exception caught updating fru[" + fru + "], exception[" + e + "]");
                Trace.trace(TRACE_MASKF, e);
                if (e instanceof HException) {
                    throw (HException)e;
                }
                throw new HException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- updateFru");
    }

    private boolean validInput(Fru fru, ExchLocPanelBean pb) throws HException {
        String sernumFromBean = pb.getSerNumTextField();
        String sernumFromFru = (String)fru.getProperties().get("SERIAL_NUM");
        boolean valid = true;
        if (sernumFromBean != null && sernumFromBean.length() > 0) {
            if (sernumFromFru != null && sernumFromFru.equals(sernumFromBean)) {
                valid = false;
                this.displayHandle.showMessageBox(false, new LocalizableText("com.ibm.hwmca.base.res.message", "perfcons.title.error"), new MessageText("com.ibm.hwmca.base.res.message", "XRV00006"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
            }
        } else if (sernumFromFru == null || sernumFromFru.length() == 0) {
            pb.setSerNumTextField("");
        } else {
            valid = false;
            this.displayHandle.showMessageBox(false, new LocalizableText("com.ibm.hwmca.base.res.message", "perfcons.title.error"), new MessageText("com.ibm.hwmca.base.res.message", "XRV00005"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
        }
        return valid;
    }
}

